/*
 * Decompiled with CFR 0.152.
 */
package music;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import music.Main;

public class getFrequency {
    private static int EXTERNAL_BUFFER_SIZE = 5000;
    private static int lowerFrequencyBound = 100;
    private static int upperFrequencyBound = 1000;

    public static void setBounds(int lower, int higher) {
        if (higher <= lower) {
            if (Main.debugErrors) {
                System.out.println("Error in getFrequency.setBounds function: lower > higher: " + higher + " > " + lower);
            }
            lowerFrequencyBound = higher;
            upperFrequencyBound = lower;
        } else {
            lowerFrequencyBound = lower;
            upperFrequencyBound = higher;
        }
    }

    public static void record(byte[] voiceData, AudioFormat linearFormat, DataLine.Info info, File audioFile, AudioInputStream linearStream, TargetDataLine targetDataLine) {
        block2: {
            EXTERNAL_BUFFER_SIZE = (int)linearFormat.getSampleRate();
            try {
                targetDataLine.start();
                linearStream.read(voiceData, 0, voiceData.length);
                targetDataLine.stop();
                ByteArrayInputStream baiStream = new ByteArrayInputStream(voiceData);
                AudioInputStream aiStream = new AudioInputStream(baiStream, linearFormat, voiceData.length);
                AudioSystem.write(aiStream, AudioFileFormat.Type.WAVE, audioFile);
                aiStream.close();
                baiStream.close();
            }
            catch (Exception e) {
                if (!Main.debugErrors) break block2;
                e.printStackTrace();
            }
        }
    }

    private static String returnNote(double highfrequency) {
        while (highfrequency > 100.88) {
            highfrequency /= 2.0;
        }
        while (highfrequency <= 50.44) {
            highfrequency *= 2.0;
        }
        if (highfrequency > 95.25) {
            return "G";
        }
        if (highfrequency > 89.905) {
            return "F#";
        }
        if (highfrequency > 84.86) {
            return "F";
        }
        if (highfrequency > 80.1) {
            return "E";
        }
        if (highfrequency > 75.6) {
            return "D#";
        }
        if (highfrequency > 71.5) {
            return "D";
        }
        if (highfrequency > 67.355) {
            return "C#";
        }
        if (highfrequency > 63.56) {
            return "C";
        }
        if (highfrequency > 60.0) {
            return "B";
        }
        if (highfrequency > 56.635) {
            return "A#";
        }
        if (highfrequency > 53.45) {
            return "A";
        }
        if (highfrequency > 50.44) {
            return "G#";
        }
        if (Main.debugErrors) {
            System.out.println("Could not decipher note " + Double.toString(highfrequency));
        }
        return "?";
    }

    public static String[] frequency(File soundFile) throws IOException {
        SourceDataLine line;
        AudioFormat audioFormat;
        AudioInputStream audioInputStream;
        block13: {
            block12: {
                audioInputStream = null;
                try {
                    audioInputStream = AudioSystem.getAudioInputStream(soundFile);
                }
                catch (Exception e) {
                    if (!Main.debugErrors) break block12;
                    e.printStackTrace();
                }
            }
            audioFormat = audioInputStream.getFormat();
            line = null;
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            try {
                line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(audioFormat);
            }
            catch (Exception e) {
                if (!Main.debugErrors) break block13;
                e.printStackTrace();
            }
        }
        int nBytesRead = 0;
        byte[] abData = new byte[EXTERNAL_BUFFER_SIZE];
        while (nBytesRead != -1) {
            block14: {
                try {
                    nBytesRead = audioInputStream.read(abData, 0, abData.length);
                }
                catch (IOException e) {
                    if (!Main.debugErrors) break block14;
                    e.printStackTrace();
                }
            }
            if (nBytesRead < 0) continue;
            int nBytesWritten = line.write(abData, 0, nBytesRead);
        }
        line.drain();
        line.close();
        float sample_rate = audioFormat.getSampleRate();
        float T = (float)audioInputStream.getFrameLength() / audioFormat.getFrameRate();
        int n = (int)(T * sample_rate) / 2;
        float h = T / (float)n;
        boolean isBigEndian = audioFormat.isBigEndian();
        int[] x = new int[n];
        int store = n * 2;
        for (int i = 0; i < store; i += 2) {
            int b1 = abData[i];
            int b2 = abData[i + 1];
            if (b1 < 0) {
                b1 += 256;
            }
            if (b2 < 0) {
                b2 += 256;
            }
            int value = !isBigEndian ? (b1 << 8) + b2 : b1 + (b2 << 8);
            x[i / 2] = value;
        }
        double[] f = new double[n / 2];
        double highfrequency = 0.0;
        double highamplitude = 0.0;
        for (int j = lowerFrequencyBound / 2; j < n / 2; ++j) {
            double firstSummation = 0.0;
            double secondSummation = 0.0;
            for (int k = n - 1; k >= 0; --k) {
                double twoPInjk = Math.PI * 2 / (double)n * (double)(j * k);
                firstSummation += (double)x[k] * Math.cos(twoPInjk);
                secondSummation += (double)x[k] * Math.sin(twoPInjk);
            }
            f[j] = Math.abs(Math.sqrt(Math.pow(firstSummation, 2.0) + Math.pow(secondSummation, 2.0)));
            double amplitude = 2.0 * f[j] / (double)n;
            double frequency = (float)j * h / T * sample_rate;
            if (!(frequency > (double)lowerFrequencyBound)) continue;
            if (!(frequency < (double)upperFrequencyBound)) break;
            if (!(amplitude > highamplitude)) continue;
            highfrequency = frequency;
            highamplitude = amplitude;
        }
        String[] returnFrequency = new String[]{getFrequency.returnNote(highfrequency), Double.toString(highamplitude)};
        return returnFrequency;
    }
}

